@echo off
setlocal enabledelayedexpansion
chcp 65001

REM Try to find Delphi installation
set "BDS="
reg query "HKLM\SOFTWARE\WOW6432Node\Embarcadero\BDS\23.0" /v RootDir >nul 2>&1
if not errorlevel 1 (
    for /f "tokens=2*" %%i in ('reg query "HKLM\SOFTWARE\WOW6432Node\Embarcadero\BDS\23.0" /v RootDir ^| findstr "RootDir"') do set "BDS=%%j"
    if defined BDS set "BDS=!BDS:~0,-1!"
) else (
    echo Delphi installation not found in registry, continuing with default paths...
)

REM Build the project
echo.
msbuild Demo.dproj -t:rebuild /p:Configuration=DEBUG /p:Platform=Win32
if errorlevel 1 (
    echo.
    echo *** BUILD FAILED! ***
    pause
    exit /b 1
)

echo.
echo Build completed successfully!

REM Check if EurekaLog is available and integrate it
echo.
if exist "D:\Lib\EurekaLog\Bin\ecc32.exe" (
    "D:\Lib\EurekaLog\Bin\ecc32.exe" --el_alter_exe"Demo.dproj"
    if errorlevel 1 (
        echo Warning: EurekaLog integration failed, but build was successful.
    ) else (
        echo EurekaLog integration completed successfully.
    )
) else (
    echo Continuing without EurekaLog integration.
)

echo.
