﻿unit uMergePDF;
{$I ..\..\..\Lib\PDFiumVcl.inc}

interface

uses
{$IFDEF XE2+}
  Winapi.Windows,
  Winapi.Messages,
  System.SysUtils,
  System.Variants,
  System.Classes,
  System.UITypes,
  Vcl.Graphics,
  Vcl.Controls,
  Vcl.Forms,
  Vcl.Dialogs,
  Vcl.XPMan,
  Vcl.ExtCtrls,
  Vcl.StdCtrls,
  Vcl.ComCtrls,
{$ELSE}
  Windows,
  Messages,
  SysUtils,
  Variants,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  XPMan,
  ExtCtrls,
  StdCtrls,
  ComCtrls,
{$ENDIF}
  PDFium;

type
  TFormMain= class(TForm)
    ListBox: TListBox;
    Panel: TPanel;
    ButtonAddFiles: TButton;
    ButtonDelete: TButton;
    ButtonMoveUp: TButton;
    ButtonMoveDown: TButton;
    ButtonMerge: TButton;
    OpenDialog: TOpenDialog;
    PdfNew: TPdf;
    Pdf: TPdf;
    ProgressBar: TProgressBar;
    procedure ButtonAddFilesClick(Sender: TObject);
    procedure ListBoxClick(Sender: TObject);
    procedure ButtonDeleteClick(Sender: TObject);
    procedure ButtonMoveUpClick(Sender: TObject);
    procedure ButtonMoveDownClick(Sender: TObject);
    procedure ButtonMergeClick(Sender: TObject);
  private
    { Private declarations }
    procedure SelectItem(ItemIndex: Integer);
    procedure UpdateButtons;
  public
    { Public declarations }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.dfm}

procedure TFormMain.SelectItem(ItemIndex: Integer);
begin
  ListBox.Selected[ItemIndex]:= True;
  ListBox.SetFocus;
end;

procedure TFormMain.UpdateButtons;
var
  ItemIndex, ItemCount: Integer;
begin
  ItemIndex:= ListBox.ItemIndex;
  ItemCount:= ListBox.Items.Count;

  ButtonAddFiles.Enabled:= True;
  ButtonDelete.Enabled:= ItemIndex<> - 1;
  ButtonMoveUp.Enabled:= (ItemIndex<> - 1)and (ItemIndex> 0);
  ButtonMoveDown.Enabled:= (ItemIndex<> - 1)and (ItemIndex< ItemCount- 1);
  ButtonMerge.Enabled:= ItemCount> 1;
end;

procedure TFormMain.ButtonAddFilesClick(Sender: TObject);
var
  I: Integer;
begin
  if OpenDialog.Execute
  then
  begin
    for I:= 0 to OpenDialog.Files.Count- 1 do
      ListBox.AddItem(OpenDialog.Files[I], nil);
    SelectItem(ListBox.Items.Count- 1);
    UpdateButtons;
  end;
end;

procedure TFormMain.ListBoxClick(Sender: TObject);
begin
  UpdateButtons;
end;

procedure TFormMain.ButtonDeleteClick(Sender: TObject);
var
  ItemIndex, ItemCount: Integer;
begin
  ItemIndex:= ListBox.ItemIndex;

  if MessageDlg('Delete '+ ListBox.Items[ItemIndex]+ '?', mtConfirmation, [mbYes, mbNo], 0)= mrYes
  then
  begin
    ListBox.Items.Delete(ItemIndex);
    ItemCount:= ListBox.Items.Count;
    if ItemIndex< ItemCount
    then
      SelectItem(ItemIndex)
    else if ItemCount> 0
    then
      SelectItem(ItemIndex- 1);
    UpdateButtons;
  end;
end;

procedure TFormMain.ButtonMoveUpClick(Sender: TObject);
var
  ItemIndex: Integer;
begin
  ItemIndex:= ListBox.ItemIndex;
  ListBox.Items.Move(ItemIndex, ItemIndex- 1);
  SelectItem(ItemIndex- 1);
  UpdateButtons;
end;

procedure TFormMain.ButtonMoveDownClick(Sender: TObject);
var
  ItemIndex: Integer;
begin
  ItemIndex:= ListBox.ItemIndex;
  ListBox.Items.Move(ItemIndex, ItemIndex+ 1);
  SelectItem(ItemIndex+ 1);
  UpdateButtons;
end;

procedure TFormMain.ButtonMergeClick(Sender: TObject);
var
  Page, I: Integer;
begin
  ProgressBar.Position:= 0;
  ProgressBar.Enabled:= True;
  Screen.Cursor:= crHourGlass;
  try
    PdfNew.CreateDocument;

    Page:= 1;
    ProgressBar.Max:= ListBox.Items.Count;
    for I:= 0 to ListBox.Items.Count- 1 do
    begin
      Pdf.FileName:= ListBox.Items[I];
      Pdf.Active:= True;
      PdfNew.ImportPages(Pdf, IntToStr(1)+ '-'+ IntToStr(Pdf.PageCount), Page);
      Inc(Page, Pdf.PageCount);
      Pdf.Active:= False;
      ProgressBar.Position:= I+ 1;
    end;

    PdfNew.SaveAs(ExtractFilePath(Application.ExeName)+ 'Merged.pdf');
    PdfNew.Active:= False;

    MessageDlg('Merge completed', mtInformation, [mbOK], 0);
  finally
    Screen.Cursor:= crDefault;
    ProgressBar.Position:= 0;
    ProgressBar.Enabled:= False;
    UpdateButtons;
    Pdf.Active:= False;
    PdfNew.Active:= False;
  end;
end;

end.
