﻿unit uFontProperties;

interface

uses
  Winapi.Windows,
  Winapi.Messages,
  System.SysUtils,
  System.Variants,
  System.Classes,
  Vcl.Graphics,
  Vcl.Controls,
  Vcl.Forms,
  Vcl.Dialogs,
  Vcl.StdCtrls,
  Vcl.ExtCtrls,
  Vcl.ComCtrls,
  PDFium;

type
  TfrmMain= class(TForm)
    pnlTop: TPanel;
    btnOpenPDF: TButton;
    edtCharIndex: TEdit;
    lblCharIndex: TLabel;
    btnGetFontInfo: TButton;
    pnlMain: TPanel;
    PdfView: TPdfView;
    Pdf: TPdf;
    memoFontInfo: TMemo;
    OpenDialog: TOpenDialog;
    Splitter1: TSplitter;
    procedure btnOpenPDFClick(Sender: TObject);
    procedure btnGetFontInfoClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PdfViewMouseDown(
      Sender: TObject;
      Button: TMouseButton;
      Shift : TShiftState;
      X, Y  : Integer);
  private
    { Private declarations }
    procedure UpdateFontInfo;
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  PdfView.Pdf:= Pdf;
  edtCharIndex.Text:= '0';
  memoFontInfo.Lines.Clear;
  memoFontInfo.Lines.Add('Open a PDF file and click on text to get font information.');
end;

procedure TfrmMain.btnOpenPDFClick(Sender: TObject);
begin
  if OpenDialog.Execute
  then
  begin
    try
      // Close current PDF if open
      if PdfView.Active
      then
        PdfView.Active:= False;
      if Pdf.Active
      then
        Pdf.Active:= False;

      Pdf.FileName:= OpenDialog.FileName;
      Pdf.Active:= True;
      PdfView.Active:= True;
      memoFontInfo.Lines.Clear;
      memoFontInfo.Lines.Add('PDF loaded successfully. Click on text to get font information.');
    except
      on E: Exception do
      begin
        ShowMessage('Error loading PDF: '+ E.Message);
      end;
    end;
  end;
end;

procedure TfrmMain.btnGetFontInfoClick(Sender: TObject);
var
  CharIndex: Integer;
begin
  if not PdfView.Active
  then
  begin
    ShowMessage('Please open a PDF file first.');
    Exit;
  end;

  try
    CharIndex:= StrToInt(edtCharIndex.Text);
    PdfView.CurrentCharIndex:= CharIndex;
    UpdateFontInfo;
  except
    on E: Exception do
    begin
      ShowMessage('Invalid character index: '+ E.Message);
    end;
  end;
end;

procedure TfrmMain.PdfViewMouseDown(
  Sender: TObject;
  Button: TMouseButton;
  Shift : TShiftState;
  X, Y  : Integer);
var
  CharIndex: Integer;
begin
  if not PdfView.Active
  then
    Exit;

  try
    CharIndex:= PdfView.CharacterIndexAtPos(X, Y, 10.0, 10.0);
    if CharIndex>= 0
    then
    begin
      edtCharIndex.Text:= IntToStr(CharIndex);
      PdfView.CurrentCharIndex:= CharIndex;
      UpdateFontInfo;
    end;
  except
    on E: Exception do
    begin
      memoFontInfo.Lines.Clear;
      memoFontInfo.Lines.Add('Error getting character at position: '+ E.Message);
    end;
  end;
end;

procedure TfrmMain.UpdateFontInfo;
var
  FontInfo: TStringList;
begin
  FontInfo:= TStringList.Create;
  try
    FontInfo.Add('=== Font Properties for Character Index: '+ IntToStr(PdfView.CurrentCharIndex)+ ' ===');
    FontInfo.Add('');

    try
      FontInfo.Add('Font Family Name: '+ PdfView.FontFamilyName);
    except
      FontInfo.Add('Font Family Name: <Error retrieving>');
    end;

    try
      FontInfo.Add('Font Base Name: '+ PdfView.FontBaseName);
    except
      FontInfo.Add('Font Base Name: <Error retrieving>');
    end;

    try
      FontInfo.Add('Font Size: '+ FloatToStr(PdfView.FontSize[PdfView.CurrentCharIndex]));
    except
      FontInfo.Add('Font Size: <Error retrieving>');
    end;

    try
      FontInfo.Add('Font Weight: '+ IntToStr(PdfView.FontWeight));
    except
      FontInfo.Add('Font Weight: <Error retrieving>');
    end;

    try
      FontInfo.Add('Font Italic Angle: '+ IntToStr(PdfView.FontItalicAngle));
    except
      FontInfo.Add('Font Italic Angle: <Error retrieving>');
    end;

    try
      FontInfo.Add('Font Ascent: '+ FloatToStr(PdfView.FontAscent));
    except
      FontInfo.Add('Font Ascent: <Error retrieving>');
    end;

    try
      FontInfo.Add('Font Descent: '+ FloatToStr(PdfView.FontDescent));
    except
      FontInfo.Add('Font Descent: <Error retrieving>');
    end;

    try
      FontInfo.Add('Font Is Embedded: '+ BoolToStr(PdfView.FontIsEmbedded, True));
    except
      FontInfo.Add('Font Is Embedded: <Error retrieving>');
    end;

    try
      FontInfo.Add('Font Data Size: '+ IntToStr(Length(PdfView.FontData))+ ' bytes');
    except
      FontInfo.Add('Font Data Size: <Error retrieving>');
    end;

    FontInfo.Add('');
    FontInfo.Add('Character: '+ PdfView.Character[PdfView.CurrentCharIndex]);

    memoFontInfo.Lines.Assign(FontInfo);
  finally
    FontInfo.Free;
  end;
end;

end.
