﻿unit uCreatePdf;
{$I ..\..\..\Lib\PDFiumVcl.inc}

interface

uses
{$IFDEF XE2+}
  Winapi.Windows,
  System.SysUtils,
  System.Classes,
  Vcl.Graphics,
  Vcl.Controls,
  Vcl.Forms,
  Vcl.Dialogs,
  Vcl.StdCtrls,
  Vcl.ExtCtrls,
{$ELSE}
  Windows,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
{$ENDIF}
  PDFium;

const
  // Simple color constants
  clLightBlue= $FFCCAA;
  clLightGreen= $CCFFCC;

type
  TFormMain= class(TForm)
    Pdf: TPdf;
    Image: TImage;
    SaveDialog: TSaveDialog;

    // Main UI
    PanelTop: TPanel;
    PanelBottom: TPanel;

    // Content Controls
    LabelTitle: TLabel;
    EditTitle: TEdit;
    LabelAuthor: TLabel;
    EditAuthor: TEdit;

    // Options
    GroupOptions: TGroupBox;
    CheckShapes: TCheckBox;
    CheckTable: TCheckBox;
    CheckWatermark: TCheckBox;

    // Actions
    ButtonCreate: TButton;
    ButtonOpen: TButton;

    // Status
    LabelStatus: TLabel;
    LinkLabel1: TLinkLabel;

    // Events
    procedure FormCreate(Sender: TObject);
    procedure ButtonCreateClick(Sender: TObject);
    procedure ButtonOpenClick(Sender: TObject);
    procedure LinkLabel1LinkClick(
      Sender    : TObject;
      const Link: string;
      LinkType  : TSysLinkType);

  private
    FLastCreatedFile: string;
    procedure CreateSimplePDF;
    procedure AddShapes;
    procedure AddTable;
    procedure AddWatermark;
    procedure UpdateStatus(const Status: string);

  public
  end;

var
  FormMain: TFormMain;

implementation

uses
{$IFDEF XE2+}
  Winapi.ShellAPI;
{$ELSE}
  ShellAPI;
{$ENDIF}
{$R *.dfm}

procedure TFormMain.FormCreate(Sender: TObject);
begin
  EditTitle.Text:= 'Sample PDF Document';
  EditAuthor.Text:= 'PDFium VCL Demo';
  UpdateStatus('Ready to create PDF');
end;

procedure TFormMain.LinkLabel1LinkClick(
  Sender    : TObject;
  const Link: string;
  LinkType  : TSysLinkType);
begin
  // Open the link in default browser
  ShellExecute(Handle, 'open', PChar(Link), nil, nil, SW_SHOWNORMAL);
end;

procedure TFormMain.ButtonCreateClick(Sender: TObject);
begin
  try
    UpdateStatus('Creating PDF...');
    CreateSimplePDF;
    UpdateStatus('PDF created successfully: '+ FLastCreatedFile);
  except
    on E: Exception do
    begin
      UpdateStatus('Error: '+ E.Message);
      ShowMessage('Error creating PDF: '+ E.Message);
    end;
  end;
end;

procedure TFormMain.CreateSimplePDF;
begin
  // Create PDF document
  Pdf.CreateDocument;
  Pdf.Active:= True;
  try
    // Add page
    Pdf.AddPage(0, 595, 842); // A4 size (page number, width, height)

    // Title
    Pdf.AddText(EditTitle.Text, 'Arial', 18, 50, 750, clBlack, $FF, 0.0);

    // Author
    Pdf.AddText('By: '+ EditAuthor.Text, 'Arial', 12, 50, 720, clGray, $FF, 0.0);

    // Content
    Pdf.AddText('This is a simple PDF document created with PDFium VCL.', 'Arial', 12, 50, 680, clBlack, $FF, 0.0);
    Pdf.AddText('You can add various elements to your PDF:', 'Arial', 12, 50, 650, clBlack, $FF, 0.0);

    // Optional features
    if CheckShapes.Checked
    then
      AddShapes;

    if CheckTable.Checked
    then
      AddTable;

    if CheckWatermark.Checked
    then
      AddWatermark;

    // Save
    FLastCreatedFile:= 'Sample.pdf';
    Pdf.SaveAs(FLastCreatedFile);

  finally
    Pdf.Active:= False;
  end;
end;

procedure TFormMain.AddShapes;
begin
  // Rectangle
  Pdf.CreatePath(100, 550, 150, 80, fmWinding, clLightBlue, $80);
  Pdf.AddPath;
  Pdf.AddText('Rectangle', 'Arial', 10, 120, 580, clBlack, $FF, 0.0);

  // Simple circle (using rectangle as placeholder)
  Pdf.CreatePath(350, 590, 80, 80, fmWinding, clLightGreen, $80);
  Pdf.AddPath;
  Pdf.AddText('Shape', 'Arial', 10, 370, 580, clBlack, $FF, 0.0);
end;

procedure TFormMain.AddTable;
var
  X, Y: Double;
  I: Integer;
begin
  X:= 100;
  Y:= 450;

  // Table header
  Pdf.AddText('Item', 'Arial', 10, X, Y, clBlack, $FF, 0.0);
  Pdf.AddText('Quantity', 'Arial', 10, X+ 100, Y, clBlack, $FF, 0.0);
  Pdf.AddText('Price', 'Arial', 10, X+ 200, Y, clBlack, $FF, 0.0);

  // Table rows
  for I:= 1 to 3 do
  begin
    Y:= Y- 20;
    Pdf.AddText('Item '+ IntToStr(I), 'Arial', 9, X, Y, clBlack, $FF, 0.0);
    Pdf.AddText(IntToStr(I), 'Arial', 9, X+ 100, Y, clBlack, $FF, 0.0);
    Pdf.AddText('$'+ IntToStr(I* 10)+ '.00', 'Arial', 9, X+ 200, Y, clBlack, $FF, 0.0);
  end;
end;

procedure TFormMain.AddWatermark;
begin
  Pdf.AddText('SAMPLE', 'Arial', 72, 200, 200, clGray, $30, 45.0);
end;

procedure TFormMain.ButtonOpenClick(Sender: TObject);
begin
  if FLastCreatedFile<> ''
  then
  begin
    if FileExists(FLastCreatedFile)
    then
      ShellExecute(0, 'OPEN', PChar(FLastCreatedFile), '', '', SW_SHOWNORMAL)
    else
      ShowMessage('File not found: '+ FLastCreatedFile);
  end
  else
    ShowMessage('No PDF file created yet. Click "Create PDF" first.');
end;

procedure TFormMain.UpdateStatus(const Status: string);
begin
  LabelStatus.Caption:= Status;
  Application.ProcessMessages;
end;

end.
