@echo off
echo Building PDF Attachment Demo...
echo.

REM Check if DCC32 is available in PATH
dcc32 >nul 2>&1
if errorlevel 1 (
    echo Error: DCC32 compiler not found in PATH
    echo Please make sure Delphi is properly installed and DCC32 is in your PATH
    pause
    exit /b 1
)

REM Build the project
echo Compiling AttachmentDemo.dpr...
dcc32 -B AttachmentDemo.dpr

if errorlevel 1 (
    echo.
    echo Build failed!
    pause
    exit /b 1
) else (
    echo.
    echo Build successful!
    echo Executable: AttachmentDemo.exe
    echo.
    echo Run the demo? (Y/N)
    set /p choice="Enter your choice: "
    if /i "%choice%"=="Y" (
        if exist AttachmentDemo.exe (
            start AttachmentDemo.exe
        ) else (
            echo AttachmentDemo.exe not found!
        )
    )
)

pause